/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.android.robotium.solo;

import android.app.Activity;
import android.app.Instrumentation;
import android.content.IntentFilter;
import android.util.Log;
import com.jayway.android.robotium.solo.Sleeper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import junit.framework.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ActivityUtils {
    private final Instrumentation inst;
    private Instrumentation.ActivityMonitor activityMonitor;
    private Activity activity;
    private final Sleeper sleeper;
    private final String LOG_TAG = "Robotium";
    private final int MINISLEEP = 100;
    private static final int ACTIVITYSYNCTIME = 50;
    private Stack<Activity> activityStack;
    private Timer activitySyncTimer;

    public ActivityUtils(Instrumentation inst, Activity activity, Sleeper sleeper) {
        this.inst = inst;
        this.activity = activity;
        this.sleeper = sleeper;
        this.createStackAndPushStartActivity();
        this.activitySyncTimer = new Timer();
        this.setupActivityMonitor();
        this.setupActivityStackListener();
    }

    private void createStackAndPushStartActivity() {
        this.activityStack = new Stack();
        if (this.activity != null) {
            this.activityStack.push(this.activity);
        }
    }

    public ArrayList<Activity> getAllOpenedActivities() {
        return new ArrayList<Activity>(this.activityStack);
    }

    private void setupActivityMonitor() {
        try {
            IntentFilter filter = null;
            this.activityMonitor = this.inst.addMonitor(filter, null, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setupActivityStackListener() {
        TimerTask activitySyncTimerTask = new TimerTask(){

            public void run() {
                Activity activity;
                if (ActivityUtils.this.activityMonitor != null && (activity = ActivityUtils.this.activityMonitor.getLastActivity()) != null) {
                    if (!ActivityUtils.this.activityStack.isEmpty() && ((Activity)ActivityUtils.this.activityStack.peek()).equals(activity)) {
                        return;
                    }
                    if (!activity.isFinishing()) {
                        ActivityUtils.this.activityStack.remove(activity);
                        ActivityUtils.this.activityStack.push(activity);
                    }
                }
            }
        };
        this.activitySyncTimer.schedule(activitySyncTimerTask, 0L, 50L);
    }

    public Instrumentation.ActivityMonitor getActivityMonitor() {
        return this.activityMonitor;
    }

    public void setActivityOrientation(int orientation) {
        Activity activity = this.getCurrentActivity();
        activity.setRequestedOrientation(orientation);
    }

    public Activity getCurrentActivity() {
        return this.getCurrentActivity(true);
    }

    private final void waitForActivityIfNotAvailable() {
        if (this.activity == null) {
            if (this.activityMonitor != null) {
                while (this.activityMonitor.getLastActivity() == null) {
                    this.sleeper.sleepMini();
                }
            } else {
                this.sleeper.sleepMini();
                this.setupActivityMonitor();
                this.waitForActivityIfNotAvailable();
            }
        }
    }

    public Activity getCurrentActivity(boolean shouldSleepFirst) {
        if (shouldSleepFirst) {
            this.sleeper.sleep();
        }
        this.waitForActivityIfNotAvailable();
        if (!this.activityStack.isEmpty()) {
            this.activity = this.activityStack.peek();
        }
        return this.activity;
    }

    public void goBackToActivity(String name) {
        int i;
        ArrayList<Activity> activitiesOpened = this.getAllOpenedActivities();
        boolean found = false;
        for (i = 0; i < activitiesOpened.size(); ++i) {
            if (!activitiesOpened.get(i).getClass().getSimpleName().equals(name)) continue;
            found = true;
            break;
        }
        if (found) {
            while (!this.getCurrentActivity().getClass().getSimpleName().equals(name)) {
                try {
                    this.inst.sendKeyDownUpSync(4);
                }
                catch (SecurityException ignored) {}
            }
        } else {
            for (i = 0; i < activitiesOpened.size(); ++i) {
                Log.d((String)"Robotium", (String)("Activity priorly opened: " + activitiesOpened.get(i).getClass().getSimpleName()));
            }
            Assert.assertTrue((String)("No Activity named " + name + " has been priorly opened"), (boolean)false);
        }
    }

    public String getString(int resId) {
        Activity activity = this.getCurrentActivity(false);
        return activity.getString(resId);
    }

    public void finalize() throws Throwable {
        try {
            if (this.activityMonitor != null) {
                this.inst.removeMonitor(this.activityMonitor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
    }

    public void finishInactiveActivities() {
        Iterator iter = this.activityStack.iterator();
        while (iter.hasNext()) {
            Activity activity = (Activity)iter.next();
            if (activity == this.getCurrentActivity()) continue;
            this.finishActivity(activity);
            iter.remove();
        }
    }

    public void finishOpenedActivities() {
        this.activitySyncTimer.cancel();
        ArrayList<Activity> activitiesOpened = this.getAllOpenedActivities();
        for (int i = activitiesOpened.size() - 1; i >= 0; --i) {
            this.sleeper.sleep(100);
            this.finishActivity(activitiesOpened.get(i));
        }
        this.finishActivity(this.getCurrentActivity());
        this.sleeper.sleepMini();
        try {
            this.inst.sendKeyDownUpSync(4);
            this.sleeper.sleep(100);
            this.inst.sendKeyDownUpSync(4);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.activityStack.clear();
    }

    private void finishActivity(Activity activity) {
        try {
            activity.finish();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

