/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.DHKeyExchange;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.RawDSA;
import com.sun.net.ssl.internal.ssl.SSLInputStream;
import com.sun.net.ssl.internal.ssl.SSLOutputStream;
import com.sun.net.ssl.internal.ssl.SessionId;
import com.sun.net.ssl.internal.ssl.X500Name;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Vector;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLKeyException;
import javax.net.ssl.SSLProtocolException;

public abstract class HandshakeMessage {
    public static final byte a = 0;
    public static final byte b = 1;
    public static final byte c = 2;
    public static final byte d = 11;
    public static final byte e = 12;
    public static final byte f = 13;
    public static final byte g = 14;
    public static final byte h = 15;
    public static final byte i = 16;
    public static final byte j = 20;
    public static final Debug debug = Debug.getInstance("ssl");

    public abstract int messageLength();

    public abstract int messageType();

    public abstract void a(PrintStream var1) throws IOException;

    public abstract void send(SSLOutputStream var1) throws IOException;

    public final void write(SSLOutputStream sSLOutputStream) throws IOException {
        int n2 = this.messageLength();
        if (n2 > 0x1000000) {
            throw new SSLException("Handshake message too big, type = " + this.messageType() + ", len = " + n2);
        }
        sSLOutputStream.write(this.messageType());
        sSLOutputStream.b(this.messageLength());
        this.send(sSLOutputStream);
    }

    public static final class HelloRequest
    extends HandshakeMessage {
        public HelloRequest() {
        }

        public HelloRequest(SSLInputStream sSLInputStream) throws IOException {
        }

        public int messageLength() {
            return 0;
        }

        public int messageType() {
            return 0;
        }

        public void a(PrintStream printStream) throws IOException {
            printStream.println("*** HelloRequest (empty)");
        }

        public void send(SSLOutputStream sSLOutputStream) throws IOException {
        }
    }

    public static final class ClientHello
    extends HandshakeMessage {
        public byte a;
        public byte b;
        public d c;
        public SessionId d;
        public byte[] e;
        public byte[] f;

        public ClientHello(SSLInputStream sSLInputStream) throws IOException {
            this.a = sSLInputStream.g();
            this.b = sSLInputStream.g();
            this.c = new d(sSLInputStream);
            this.d = new SessionId(sSLInputStream.c());
            this.e = sSLInputStream.a();
            this.f = sSLInputStream.c();
        }

        public ClientHello(SecureRandom secureRandom) {
            this.a = (byte)3;
            this.b = 1;
            this.c = new d(secureRandom);
            this.f = new byte[1];
        }

        public int messageLength() {
            return 38 + this.d.b() + this.e.length + this.f.length;
        }

        public int messageType() {
            return 1;
        }

        public void a(PrintStream printStream) throws IOException {
            printStream.println("*** ClientHello, v" + this.a + "." + this.b);
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("RandomCookie:  ");
                this.c.a(printStream);
                printStream.print("Session ID:  ");
                printStream.println(this.d);
                printStream.print("Cipher Suites:  { ");
                int n2 = 0;
                while (n2 < this.e.length) {
                    if (n2 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.e[n2]);
                    ++n2;
                }
                printStream.println(" }");
                printStream.print("Compression Methods:  { ");
                n2 = 0;
                while (n2 < this.f.length) {
                    if (n2 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.f[n2]);
                    ++n2;
                }
                printStream.println(" }");
                printStream.println("***");
            }
        }

        public void send(SSLOutputStream sSLOutputStream) throws IOException {
            sSLOutputStream.d(this.a);
            sSLOutputStream.d(this.b);
            this.c.a(sSLOutputStream);
            sSLOutputStream.c(this.d.a());
            sSLOutputStream.a(this.e);
            sSLOutputStream.c(this.f);
        }
    }

    public static final class ServerHello
    extends HandshakeMessage {
        public byte a;
        public byte b;
        public d c;
        public SessionId d;
        public byte[] e;
        public byte f;

        public ServerHello() {
        }

        public ServerHello(SSLInputStream sSLInputStream) throws IOException {
            this.a = sSLInputStream.g();
            this.b = sSLInputStream.g();
            this.c = new d(sSLInputStream);
            this.d = new SessionId(sSLInputStream.c());
            this.e = new byte[2];
            this.e[0] = sSLInputStream.g();
            this.e[1] = sSLInputStream.g();
            this.f = sSLInputStream.g();
        }

        public int messageLength() {
            return 38 + this.d.b();
        }

        public int messageType() {
            return 2;
        }

        public void a(PrintStream printStream) throws IOException {
            printStream.println("*** ServerHello, v" + this.a + "." + this.b);
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("RandomCookie:  ");
                this.c.a(printStream);
                printStream.print("Session ID:  ");
                printStream.println(this.d);
                printStream.println("Cipher Suite:  { " + this.e[0] + ", " + this.e[1] + " }");
                printStream.println("Compression Method: " + this.f);
                printStream.println("***");
            }
        }

        public void send(SSLOutputStream sSLOutputStream) throws IOException {
            sSLOutputStream.d(this.a);
            sSLOutputStream.d(this.b);
            this.c.a(sSLOutputStream);
            sSLOutputStream.c(this.d.a());
            sSLOutputStream.d(this.e[0]);
            sSLOutputStream.d(this.e[1]);
            sSLOutputStream.d(this.f);
        }
    }

    public static final class CertificateMsg
    extends HandshakeMessage {
        public X509Certificate[] a;

        public CertificateMsg(SSLInputStream sSLInputStream) throws IOException {
            int n2;
            int n3 = sSLInputStream.e();
            Vector<Certificate> vector = new Vector<Certificate>(3);
            while (n3 > 0) {
                n2 = sSLInputStream.e();
                byte[] byArray = new byte[n2];
                int n4 = 0;
                n3 -= 3 + n2;
                while (n4 != n2) {
                    int n5 = sSLInputStream.read(byArray, n4, n2 - n4);
                    if (n5 < 0) {
                        throw new IOException("short read of certificates");
                    }
                    n4 += n5;
                }
                try {
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    vector.addElement(certificateFactory.generateCertificate(new ByteArrayInputStream(byArray)));
                }
                catch (CertificateException certificateException) {
                    throw new IOException(certificateException.getMessage());
                }
            }
            this.a = new X509Certificate[vector.size()];
            n2 = 0;
            while (n2 < this.a.length) {
                this.a[n2] = (X509Certificate)vector.elementAt(n2);
                ++n2;
            }
        }

        public CertificateMsg(X509Certificate[] x509CertificateArray) {
            this.a = x509CertificateArray;
        }

        public X509Certificate[] getCertificateChain() {
            return this.a;
        }

        public int messageLength() {
            int n2 = 3;
            try {
                int n3 = this.a.length - 1;
                while (n3 >= 0) {
                    n2 += 3 + this.a[n3].getEncoded().length;
                    --n3;
                }
            }
            catch (CertificateException certificateException) {}
            return n2;
        }

        public int messageType() {
            return 11;
        }

        public void a(PrintStream printStream) throws IOException {
            printStream.println("*** Certificate chain");
            if (debug != null && Debug.isOn("verbose")) {
                int n2 = 0;
                while (n2 < this.a.length) {
                    printStream.println("chain [" + n2 + "] = " + this.a[n2]);
                    ++n2;
                }
                printStream.println("***");
            }
        }

        public void send(SSLOutputStream sSLOutputStream) throws IOException {
            try {
                sSLOutputStream.b(this.messageLength() - 3);
                int n2 = 0;
                while (n2 < this.a.length) {
                    sSLOutputStream.b(this.a[n2].getEncoded());
                    ++n2;
                }
            }
            catch (CertificateException certificateException) {
                throw new IOException(certificateException.getMessage());
            }
        }
    }

    public static abstract class ServerKeyExchange
    extends HandshakeMessage {
        public int messageType() {
            return 12;
        }
    }

    public static final class RSA_ServerKeyExchange
    extends ServerKeyExchange {
        public byte[] a;
        public byte[] b;
        public e c;

        public RSA_ServerKeyExchange(SSLInputStream sSLInputStream, int n2) throws IOException, InvalidKeyException, SignatureException {
            this.a = sSLInputStream.a();
            this.b = sSLInputStream.a();
            byte[] byArray = sSLInputStream.a();
            this.c = new e(byArray);
        }

        public RSA_ServerKeyExchange(RSAPublicKey rSAPublicKey, PrivateKey privateKey, d d10, d d11) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            this.a = rSAPublicKey.getModulus().toByteArray();
            this.b = rSAPublicKey.getPublicExponent().toByteArray();
            byte[] byArray = this.a("MD5", d10.a, d11.a);
            byte[] byArray2 = this.a("SHA-1", d10.a, d11.a);
            this.c = new e(byArray, byArray2, privateKey);
        }

        private byte[] a(String string, byte[] byArray, byte[] byArray2) throws NoSuchAlgorithmException {
            MessageDigest messageDigest = MessageDigest.getInstance(string);
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            int n2 = this.a.length;
            messageDigest.update((byte)(n2 >> 8));
            messageDigest.update((byte)(n2 & 0xFF));
            messageDigest.update(this.a);
            n2 = this.b.length;
            messageDigest.update((byte)(n2 >> 8));
            messageDigest.update((byte)(n2 & 0xFF));
            messageDigest.update(this.b);
            return messageDigest.digest();
        }

        public RSAPublicKey a() {
            RSAPublicKey rSAPublicKey = null;
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(new BigInteger(this.a), new BigInteger(this.b));
                rSAPublicKey = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (Exception exception) {}
            return rSAPublicKey;
        }

        public int messageLength() {
            return 6 + this.a.length + this.b.length + this.c.a().length;
        }

        public void a(PrintStream printStream) throws IOException {
            printStream.println("*** RSA ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("RSA Modulus:  { ");
                int n2 = 0;
                while (n2 < this.a.length) {
                    if (n2 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.a[n2] & 0xFF);
                    ++n2;
                }
                printStream.println(" }");
                printStream.print("RSA Public Exponent:  { ");
                n2 = 0;
                while (n2 < this.b.length) {
                    if (n2 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.b[n2] & 0xFF);
                    ++n2;
                }
                printStream.println(" }");
            }
        }

        public void send(SSLOutputStream sSLOutputStream) throws IOException {
            sSLOutputStream.a(this.a);
            sSLOutputStream.a(this.b);
            sSLOutputStream.a(this.c.a());
        }

        public boolean a(RSAPublicKey rSAPublicKey, d d10, d d11) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            byte[] byArray = this.a("MD5", d10.a, d11.a);
            byte[] byArray2 = this.a("SHA-1", d10.a, d11.a);
            return this.c.a(rSAPublicKey, byArray, byArray2);
        }
    }

    public static final class DH_ServerKeyExchange
    extends ServerKeyExchange {
        public byte[] a;
        public byte[] b;
        public byte[] c;
        public byte[] d;

        public DH_ServerKeyExchange(DHKeyExchange dHKeyExchange) {
            this.a(dHKeyExchange);
            this.d = null;
        }

        public DH_ServerKeyExchange(DHKeyExchange dHKeyExchange, PrivateKey privateKey, byte[] byArray, byte[] byArray2) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            this.a(dHKeyExchange);
            if (privateKey instanceof DSAPrivateKey) {
                Signature signature = Signature.getInstance("DSA");
                signature.initSign(privateKey);
                this.a(signature, byArray, byArray2);
                this.d = signature.sign();
            } else {
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-1");
                this.a(messageDigest, byArray, byArray2);
                this.a(messageDigest2, byArray, byArray2);
                e e2 = new e(messageDigest.digest(), messageDigest2.digest(), privateKey);
                this.d = e2.a();
            }
        }

        public DH_ServerKeyExchange(SSLInputStream sSLInputStream) throws IOException {
            this.a = sSLInputStream.a();
            this.b = sSLInputStream.a();
            this.c = sSLInputStream.a();
            this.d = null;
        }

        public DH_ServerKeyExchange(SSLInputStream sSLInputStream, PublicKey publicKey, byte[] byArray, byte[] byArray2, int n2) throws IOException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
            boolean bl2;
            this.a = sSLInputStream.a();
            this.b = sSLInputStream.a();
            this.c = sSLInputStream.a();
            n2 -= this.a.length + 2;
            n2 -= this.b.length + 2;
            this.d = new byte[n2 -= this.c.length + 2];
            sSLInputStream.read(this.d);
            if (publicKey instanceof DSAKey) {
                Signature signature = Signature.getInstance("DSA");
                signature.initVerify(publicKey);
                this.a(signature, byArray, byArray2);
                bl2 = signature.verify(this.d);
            } else if (publicKey instanceof RSAPublicKey) {
                e e2 = new e(this.d);
                MessageDigest messageDigest = MessageDigest.getInstance("MD5");
                MessageDigest messageDigest2 = MessageDigest.getInstance("SHA-1");
                this.a(messageDigest, byArray, byArray2);
                this.a(messageDigest2, byArray, byArray2);
                bl2 = e2.a((RSAPublicKey)publicKey, messageDigest.digest(), messageDigest2.digest());
            } else {
                throw new SSLKeyException("neither an RSA or a DSA key");
            }
            if (!bl2) {
                throw new SSLKeyException("Server D-H key verification failed");
            }
        }

        public BigInteger getBase() {
            return new BigInteger(1, this.b);
        }

        public BigInteger getModulus() {
            return new BigInteger(1, this.a);
        }

        public BigInteger getServerPublicKey() {
            return new BigInteger(1, this.c);
        }

        private void a(DHKeyExchange dHKeyExchange) {
            this.a = dHKeyExchange.getModulus().toByteArray();
            this.b = dHKeyExchange.getBase().toByteArray();
            this.c = dHKeyExchange.getPublicKey().toByteArray();
        }

        public int messageLength() {
            int n2 = 6;
            n2 += this.a.length;
            n2 += this.b.length;
            n2 += this.c.length;
            if (this.d != null) {
                n2 += this.d.length;
            }
            return n2;
        }

        public void a(PrintStream printStream) throws IOException {
            printStream.println("*** Diffie-Hellman ServerKeyExchange");
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("DH Modulus = { ");
                int n2 = 0;
                while (n2 < this.a.length) {
                    if (n2 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.a[n2] & 0xFF);
                    ++n2;
                }
                printStream.println(" }");
                printStream.print("DH Base = { ");
                int n3 = 0;
                while (n3 < this.b.length) {
                    if (n3 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.b[n3] & 0xFF);
                    ++n3;
                }
                printStream.println(" }");
                printStream.print("Server DH Public Key = { ");
                int n4 = 0;
                while (n4 < this.c.length) {
                    if (n4 != 0) {
                        printStream.print(", ");
                    }
                    printStream.print(this.c[n4] & 0xFF);
                    ++n4;
                }
                printStream.println(" }");
                if (this.d == null) {
                    printStream.println("Anonymous");
                } else {
                    printStream.println("Signed with a DSA or RSA public key");
                }
            }
        }

        public void send(SSLOutputStream sSLOutputStream) throws IOException {
            sSLOutputStream.a(this.a);
            sSLOutputStream.a(this.b);
            sSLOutputStream.a(this.c);
            if (this.d != null) {
                sSLOutputStream.write(this.d);
            }
        }

        private void a(MessageDigest messageDigest, byte[] byArray, byte[] byArray2) {
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            int n2 = this.a.length;
            messageDigest.update((byte)(n2 >> 8));
            messageDigest.update((byte)(n2 & 0xFF));
            messageDigest.update(this.a);
            n2 = this.b.length;
            messageDigest.update((byte)(n2 >> 8));
            messageDigest.update((byte)(n2 & 0xFF));
            messageDigest.update(this.b);
            n2 = this.c.length;
            messageDigest.update((byte)(n2 >> 8));
            messageDigest.update((byte)(n2 & 0xFF));
            messageDigest.update(this.c);
        }

        private void a(Signature signature, byte[] byArray, byte[] byArray2) throws SignatureException {
            signature.update(byArray);
            signature.update(byArray2);
            int n2 = this.a.length;
            signature.update((byte)(n2 >> 8));
            signature.update((byte)(n2 & 0xFF));
            signature.update(this.a);
            n2 = this.b.length;
            signature.update((byte)(n2 >> 8));
            signature.update((byte)(n2 & 0xFF));
            signature.update(this.b);
            n2 = this.c.length;
            signature.update((byte)(n2 >> 8));
            signature.update((byte)(n2 & 0xFF));
            signature.update(this.c);
        }
    }

    public static final class CertificateRequest
    extends HandshakeMessage {
        public static final int a = 1;
        public static final int b = 2;
        public static final int c = 3;
        public static final int d = 4;
        public static final int e = 5;
        public static final int f = 6;
        public byte[] g;
        public f[] h;

        public CertificateRequest(SSLInputStream sSLInputStream) throws IOException {
            this.g = sSLInputStream.c();
            int n2 = sSLInputStream.d();
            Vector<f> vector = new Vector<f>();
            while (n2 >= 3) {
                f f2 = new f(sSLInputStream);
                vector.addElement(f2);
                n2 -= f2.a();
            }
            if (n2 != 0) {
                throw new SSLProtocolException("Bad CertificateRequest DN length");
            }
            int n3 = vector.size();
            this.h = new f[n3];
            int n4 = 0;
            while (n4 < n3) {
                this.h[n4] = (f)vector.elementAt(n4);
                ++n4;
            }
        }

        public CertificateRequest(X509Certificate[] x509CertificateArray, int n2) throws IOException {
            this.h = new f[x509CertificateArray.length];
            int n3 = 0;
            while (n3 < x509CertificateArray.length) {
                X500Name x500Name = new X500Name(x509CertificateArray[n3].getSubjectDN().getName());
                this.h[n3] = new f(x500Name);
                ++n3;
            }
            switch (n2) {
                case 1: 
                case 2: 
                case 5: 
                case 6: {
                    this.g = new byte[2];
                    this.g[0] = 2;
                    this.g[1] = 1;
                    break;
                }
                case 3: {
                    this.g = new byte[1];
                    this.g[0] = 3;
                    break;
                }
                case 4: {
                    this.g = new byte[1];
                    this.g[0] = 4;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported or illegal SSL client auth key exchange");
                }
            }
        }

        public Principal[] a() throws IOException {
            Principal[] principalArray = new Principal[this.h.length];
            int n2 = 0;
            while (n2 < this.h.length) {
                principalArray[n2] = new X500Name(new DerInputStream(this.h[n2].a));
                ++n2;
            }
            return principalArray;
        }

        public int messageLength() {
            int n2 = 1 + this.g.length + 2;
            int n3 = 0;
            while (n3 < this.h.length) {
                n2 += this.h[n3].a();
                ++n3;
            }
            return n2;
        }

        public int messageType() {
            return 13;
        }

        public void a(PrintStream printStream) throws IOException {
            printStream.println("*** CertificateRequest");
            if (debug != null && Debug.isOn("verbose")) {
                printStream.print("Cert Types: ");
                int n2 = 0;
                while (n2 < this.g.length) {
                    switch (this.g[n2]) {
                        case 1: {
                            printStream.print("RSA");
                            break;
                        }
                        case 2: {
                            printStream.print("DSS");
                            break;
                        }
                        case 3: {
                            printStream.print("Fixed DH (RSA sig)");
                            break;
                        }
                        case 4: {
                            printStream.print("Fixed DH (DSS sig)");
                            break;
                        }
                        case 5: {
                            printStream.print("Ephemeral DH (RSA sig)");
                            break;
                        }
                        case 6: {
                            printStream.print("Ephemeral DH (DSS sig)");
                            break;
                        }
                        default: {
                            printStream.print("Type-" + this.g[n2]);
                        }
                    }
                    if (n2 != this.g.length) {
                        printStream.print(", ");
                    }
                    ++n2;
                }
                printStream.println();
                printStream.println("Cert Authorities:");
                int n3 = 0;
                while (n3 < this.h.length) {
                    this.h[n3].a(printStream);
                    ++n3;
                }
            }
        }

        public void send(SSLOutputStream sSLOutputStream) throws IOException {
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.h.length) {
                n2 += this.h[n3].a();
                ++n3;
            }
            sSLOutputStream.c(this.g);
            sSLOutputStream.a(n2);
            int n4 = 0;
            while (n4 < this.h.length) {
                this.h[n4].a(sSLOutputStream);
                ++n4;
            }
        }
    }

    public static final class ServerHelloDone
    extends HandshakeMessage {
        public ServerHelloDone() {
        }

        public ServerHelloDone(SSLInputStream sSLInputStream) {
        }

        public int messageLength() {
            return 0;
        }

        public int messageType() {
            return 14;
        }

        public void a(PrintStream printStream) throws IOException {
            printStream.println("*** ServerHelloDone");
        }

        public void send(SSLOutputStream sSLOutputStream) throws IOException {
        }
    }

    public static final class CertificateVerify
    extends HandshakeMessage {
        public byte[] a;

        public CertificateVerify(byte by2, PrivateKey privateKey, MessageDigest messageDigest, byte[] byArray) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
            Signature signature;
            if (by2 == 0) {
                signature = Signature.getInstance("DSA");
                messageDigest.update(byArray);
                messageDigest.update(MAC.SHA_pad1);
                byte[] byArray2 = messageDigest.digest();
                signature.initSign(privateKey);
                signature.update(byArray);
                signature.update(MAC.SHA_pad2);
                signature.update(byArray2);
            } else {
                signature = new RawDSA();
                signature.initSign(privateKey);
                signature.update(messageDigest.digest());
            }
            this.a = signature.sign();
        }

        public CertificateVerify(byte by2, RSAPrivateKey rSAPrivateKey, MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            byte[] byArray2;
            byte[] byArray3;
            if (by2 == 0) {
                byArray3 = this.a(messageDigest, MAC.MD5_pad1, MAC.MD5_pad2, byArray);
                byArray2 = this.a(messageDigest2, MAC.SHA_pad1, MAC.SHA_pad2, byArray);
            } else {
                byArray3 = messageDigest.digest();
                byArray2 = messageDigest2.digest();
            }
            e e2 = new e(byArray3, byArray2, rSAPrivateKey);
            this.a = e2.a();
        }

        public CertificateVerify(SSLInputStream sSLInputStream) throws IOException {
            this.a = sSLInputStream.a();
        }

        private byte[] a(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, byte[] byArray3) {
            messageDigest.update(byArray3);
            messageDigest.update(byArray);
            byte[] byArray4 = messageDigest.digest();
            messageDigest.reset();
            messageDigest.update(byArray3);
            messageDigest.update(byArray2);
            messageDigest.update(byArray4);
            return messageDigest.digest();
        }

        public int messageLength() {
            return 2 + this.a.length;
        }

        public int messageType() {
            return 15;
        }

        public void a(PrintStream printStream) throws IOException {
            printStream.println("*** CertificateVerify");
        }

        public void send(SSLOutputStream sSLOutputStream) throws IOException {
            sSLOutputStream.a(this.a);
        }

        public boolean a(byte by2, PublicKey publicKey, MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
            if (publicKey instanceof RSAPublicKey) {
                return this.a(by2, (RSAPublicKey)publicKey, messageDigest, messageDigest2, byArray);
            }
            return this.a(by2, publicKey, messageDigest2, byArray);
        }

        private boolean a(byte by2, PublicKey publicKey, MessageDigest messageDigest, byte[] byArray) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            Signature signature;
            if (by2 == 0) {
                signature = Signature.getInstance("DSA");
                messageDigest.update(byArray);
                messageDigest.update(MAC.SHA_pad1);
                byte[] byArray2 = messageDigest.digest();
                signature.initVerify(publicKey);
                signature.update(byArray);
                signature.update(MAC.SHA_pad2);
                signature.update(byArray2);
            } else {
                signature = new RawDSA();
                signature.initVerify(publicKey);
                signature.update(messageDigest.digest());
            }
            return signature.verify(this.a);
        }

        private boolean a(byte by2, RSAPublicKey rSAPublicKey, MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray) throws InvalidKeyException, NoSuchAlgorithmException, SignatureException {
            byte[] byArray2;
            byte[] byArray3;
            if (by2 == 0) {
                byArray3 = this.a(messageDigest, MAC.MD5_pad1, MAC.MD5_pad2, byArray);
                byArray2 = this.a(messageDigest2, MAC.SHA_pad1, MAC.SHA_pad2, byArray);
            } else {
                byArray3 = messageDigest.digest();
                byArray2 = messageDigest2.digest();
            }
            e e2 = new e(this.a);
            return e2.a(rSAPublicKey, byArray3, byArray2);
        }
    }

    public static final class Finished
    extends HandshakeMessage {
        public byte a;
        public byte b;
        public static final byte[] c = new byte[]{67, 76, 78, 84};
        public static final byte[] d = new byte[]{83, 82, 86, 82};
        public static final String e = "client finished";
        public static final String f = "server finished";
        public byte[] g;
        public byte[] h;
        public byte[] i;

        public Finished(byte by2, byte by3, SSLInputStream sSLInputStream) throws IOException {
            this.a = by2;
            this.b = by3;
            if (by2 == 3 && by3 == 1) {
                this.i = new byte[12];
                sSLInputStream.read(this.i);
            } else {
                this.g = new byte[16];
                this.h = new byte[20];
                sSLInputStream.read(this.g);
                sSLInputStream.read(this.h);
            }
        }

        public Finished(byte by2, byte by3, MessageDigest messageDigest, MessageDigest messageDigest2, String string, byte[] byArray) {
            this.a = by2;
            this.b = by3;
            this.i = new byte[12];
            try {
                g.a(byArray, string, messageDigest.digest(), messageDigest2.digest(), this.i);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new RuntimeException("missing support for MD5/SHA-1");
            }
        }

        public Finished(byte by2, byte by3, MessageDigest messageDigest, MessageDigest messageDigest2, byte[] byArray, byte[] byArray2) {
            this.a = by2;
            this.b = by3;
            this.g = this.a(messageDigest, byArray, byArray2, MAC.MD5_pad1, MAC.MD5_pad2);
            this.h = this.a(messageDigest2, byArray, byArray2, MAC.SHA_pad1, MAC.SHA_pad2);
        }

        private byte[] a(MessageDigest messageDigest, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) {
            messageDigest.update(byArray);
            messageDigest.update(byArray2);
            messageDigest.update(byArray3);
            byte[] byArray5 = messageDigest.digest();
            messageDigest.reset();
            messageDigest.update(byArray2);
            messageDigest.update(byArray4);
            messageDigest.update(byArray5);
            return messageDigest.digest();
        }

        public int messageLength() {
            if (this.a == 3 && this.b == 1) {
                return 12;
            }
            return 36;
        }

        public int messageType() {
            return 20;
        }

        public void a(PrintStream printStream) throws IOException {
            printStream.println("*** Finished, v" + this.a + "." + this.b);
            if (debug != null && Debug.isOn("verbose")) {
                if (this.a == 3 && this.b == 1) {
                    printStream.print("verify_data:  { ");
                    int n2 = 0;
                    while (n2 < this.i.length) {
                        if (n2 != 0) {
                            printStream.print(", ");
                        }
                        printStream.print(this.i[n2] & 0xFF);
                        ++n2;
                    }
                    printStream.println(" }");
                    printStream.println("***");
                } else {
                    printStream.print("MD5 Hash:  { ");
                    int n3 = 0;
                    while (n3 < this.g.length) {
                        if (n3 != 0) {
                            printStream.print(", ");
                        }
                        printStream.print(this.g[n3] & 0xFF);
                        ++n3;
                    }
                    printStream.println(" }");
                    printStream.print("SHA1 Hash:  { ");
                    n3 = 0;
                    while (n3 < this.h.length) {
                        if (n3 != 0) {
                            printStream.print(", ");
                        }
                        printStream.print(this.h[n3] & 0xFF);
                        ++n3;
                    }
                    printStream.println(" }");
                    printStream.println("***");
                }
            }
        }

        public void send(SSLOutputStream sSLOutputStream) throws IOException {
            if (this.a == 3 && this.b == 1) {
                sSLOutputStream.write(this.i);
            } else {
                sSLOutputStream.write(this.g);
                sSLOutputStream.write(this.h);
            }
        }

        public boolean verify(MessageDigest messageDigest, MessageDigest messageDigest2, Object object, byte[] byArray) {
            if (object instanceof String) {
                if (this.i == null) {
                    return false;
                }
                byte[] byArray2 = new byte[12];
                try {
                    g.a(byArray, (String)object, messageDigest.digest(), messageDigest2.digest(), byArray2);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new RuntimeException("missing support for MD5/SHA-1");
                }
                int n2 = 0;
                while (n2 < 12) {
                    if (this.i[n2] != byArray2[n2]) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            if (this.g == null || this.h == null) {
                return false;
            }
            byte[] byArray3 = this.a(messageDigest, (byte[])object, byArray, MAC.MD5_pad1, MAC.MD5_pad2);
            byte[] byArray4 = this.a(messageDigest2, (byte[])object, byArray, MAC.SHA_pad1, MAC.SHA_pad2);
            int n3 = 0;
            while (n3 < 16) {
                if (this.g[n3] != byArray3[n3]) {
                    return false;
                }
                ++n3;
            }
            n3 = 0;
            while (n3 < 20) {
                if (this.h[n3] != byArray4[n3]) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
    }
}

