/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

function initPrefs()
{
    var dir = getSpecialDirectory("ProfD");
    dir.append("venkman-settings.js");
    var defaultSettingsFile = dir.path;

    console.prefManager = new PrefManager("extensions.venkman.");
    console.prefs = console.prefManager.prefs;
    
    var prefs =
        [
         ["enableChromeFilter", true],
         ["guessContext", 5],
         ["guessPattern", "(\\w+)\\s*[:=]\\s*$"],
         ["initialScripts", ""],
         ["initJSDAtStartup", false],
         ["lastErrorMode", "ignore"],
         ["lastThrowMode", "ignore"],
         ["maxStringLength", 4000],
         ["menubarInFloaters", navigator.platform.indexOf ("Mac") != -1],
         ["permitStartupHit", true],
         ["prettyprint", false],
         ["rememberPrettyprint", false],
         ["saveSettingsOnExit", false],
         ["settingsFile", defaultSettingsFile],
         ["startupCount", 0],
         ["statusDuration", 5 * 1000],
         ["tabWidth", 4]
        ];

    console.prefManager.addPrefs(prefs);
}

function destroyPrefs()
{
    console.prefManager.destroy();
}
