/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef nsAHtml5TreeBuilderState_h___
#define nsAHtml5TreeBuilderState_h___

/**
 * Interface for exposing the internal state of the HTML5 tree builder.
 * For more documentation, please see
 * http://hg.mozilla.org/projects/htmlparser/file/tip/src/nu/validator/htmlparser/impl/StateSnapshot.java
 */
class nsAHtml5TreeBuilderState {
  public:
  
    virtual jArray<nsHtml5StackNode*,PRInt32> getStack() = 0;
    
    virtual jArray<nsHtml5StackNode*,PRInt32> getListOfActiveFormattingElements() = 0;
    
    virtual PRInt32 getStackLength() = 0;

    virtual PRInt32 getListOfActiveFormattingElementsLength() = 0;

    virtual nsIContent** getFormPointer() = 0;
    
    virtual nsIContent** getHeadPointer() = 0;

    virtual nsIContent** getDeepTreeSurrogateParent() = 0;

    virtual PRInt32 getMode() = 0;

    virtual PRInt32 getOriginalMode() = 0;

    virtual bool isFramesetOk() = 0;

    virtual bool isNeedToDropLF() = 0;

    virtual bool isQuirks() = 0;
    
    virtual ~nsAHtml5TreeBuilderState() {
    }
};

#endif /* nsAHtml5TreeBuilderState_h___ */
