/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.DerInputStream;
import com.sun.net.ssl.internal.ssl.DerOutputStream;
import com.sun.net.ssl.internal.ssl.DerValue;
import com.sun.net.ssl.internal.ssl.ObjectIdentifier;
import com.sun.net.ssl.internal.ssl.X500Name;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class AVA {
    public ObjectIdentifier a;
    public DerValue b;
    public static final String c = ",+=\n<>#;";
    public static final String d = "0123456789ABCDEF";

    public AVA(DerInputStream derInputStream) throws IOException {
        DerValue derValue = derInputStream.getDerValue();
        if (derValue.tag != 48) {
            throw new IOException("X500 AVA, not a sequence");
        }
        this.a = X500Name.b(derValue.data.getOID());
        this.b = derValue.data.getDerValue();
        if (derValue.data.available() != 0) {
            throw new IOException("AVA, extra bytes = " + derValue.data.available());
        }
    }

    public AVA(ObjectIdentifier objectIdentifier, DerValue derValue) {
        this.a = objectIdentifier;
        this.b = derValue;
    }

    public AVA(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            int n2;
            if ((n2 = inputStream.read()) == -1) {
                throw new IOException("Incorrect AVA format");
            }
            if ((char)n2 == '=') break;
            stringBuffer.append((char)n2);
        }
        String string = stringBuffer.toString().toUpperCase().trim();
        if (string.equals("CN")) {
            this.a = X500Name.commonName_oid;
        } else if (string.equals("C")) {
            this.a = X500Name.countryName_oid;
        } else if (string.equals("L")) {
            this.a = X500Name.localityName_oid;
        } else if (string.equals("S") || string.equals("ST")) {
            this.a = X500Name.stateName_oid;
        } else if (string.equals("O")) {
            this.a = X500Name.orgName_oid;
        } else if (string.equals("OU")) {
            this.a = X500Name.orgUnitName_oid;
        } else if (string.equals("T")) {
            this.a = X500Name.title_oid;
        } else if (string.equals("IP")) {
            this.a = X500Name.ipAddress_oid;
        } else if (string.equals("STREET")) {
            this.a = X500Name.streetAddress_oid;
        } else if (string.equals("EMAILADDRESS")) {
            this.a = X500Name.emailAddress_oid;
        } else {
            throw new IOException("unsupported keyword " + string);
        }
        stringBuffer = new StringBuffer();
        char c10 = (char)inputStream.read();
        while (c10 == ' ' || c10 == '\n') {
            c10 = (char)inputStream.read();
        }
        if (c10 == '\uffffffff') {
            throw new IOException("Incorrect AVA format");
        }
        if (c10 == '#') {
            throw new IOException("AVA parse, hex values NYI");
        }
        if (c10 == '\"') {
            c10 = (char)inputStream.read();
            while (c10 != '\uffffffff' && c10 != '\"') {
                stringBuffer.append(c10);
                c10 = (char)inputStream.read();
            }
            this.b = new DerValue(stringBuffer.toString().trim());
        } else {
            int n3;
            do {
                if (c10 == '\\') {
                    c10 = (char)inputStream.read();
                }
                stringBuffer.append(c10);
                n3 = inputStream.read();
                c10 = (char)n3;
            } while (n3 != -1 && c10 != '+' && c10 != ',' && c10 != ';' && c10 != '>');
            this.b = new DerValue(stringBuffer.toString().trim());
        }
    }

    public void derEncode(OutputStream outputStream) throws IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        DerOutputStream derOutputStream2 = new DerOutputStream();
        derOutputStream.putOID(this.a);
        this.b.encode(derOutputStream);
        derOutputStream2.write((byte)48, derOutputStream);
        outputStream.write(derOutputStream2.toByteArray());
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        this.derEncode(derOutputStream);
    }

    public boolean a(AVA aVA) {
        return this.a.equals(aVA.a) && this.b.equals(aVA.b);
    }

    public boolean equals(Object object) {
        if (object instanceof AVA) {
            return this.a((AVA)object);
        }
        return false;
    }

    public String toString() {
        String string = this.a.equals(X500Name.commonName_oid) ? "CN" : (this.a.equals(X500Name.countryName_oid) ? "C" : (this.a.equals(X500Name.localityName_oid) ? "L" : (this.a.equals(X500Name.stateName_oid) ? "ST" : (this.a.equals(X500Name.orgName_oid) ? "O" : (this.a.equals(X500Name.orgUnitName_oid) ? "OU" : (this.a.equals(X500Name.title_oid) ? "T" : (this.a.equals(X500Name.ipAddress_oid) ? "IP" : (this.a.equals(X500Name.streetAddress_oid) ? "STREET" : (this.a.equals(X500Name.emailAddress_oid) ? "EmailAddress" : "OID." + this.a.toString())))))))));
        StringBuffer stringBuffer = new StringBuffer(30);
        stringBuffer.append(string);
        stringBuffer.append("=");
        try {
            String string2 = this.b.getAsString();
            if (string2 == null) {
                byte[] byArray = this.b.toByteArray();
                stringBuffer.append('#');
                int n2 = 0;
                while (n2 < byArray.length) {
                    stringBuffer.append(d.charAt(byArray[n2] >> 4 & 0xF));
                    stringBuffer.append(d.charAt(byArray[n2] & 0xF));
                    ++n2;
                }
            } else {
                char c10;
                boolean bl2 = false;
                int n3 = string2.length();
                int n4 = 0;
                while (n4 < c.length()) {
                    if (string2.indexOf(c.charAt(n4)) != -1) {
                        bl2 = true;
                        break;
                    }
                    ++n4;
                }
                if (!(n3 <= 0 || bl2 || string2.charAt(0) != ' ' && string2.charAt(0) != '\n' && string2.charAt(n3 - 1) != ' ' && string2.charAt(n3 - 1) != '\n')) {
                    bl2 = true;
                }
                if (n3 > 0 && !bl2) {
                    c10 = '\u0000';
                    n4 = 1;
                    while (n4 < n3 - 2) {
                        if (string2.charAt(n4) == ' ' || string2.charAt(n4) == '\n') {
                            if (c10 != '\u0000') {
                                bl2 = true;
                                break;
                            }
                            c10 = '\u0001';
                        } else {
                            c10 = '\u0000';
                        }
                        ++n4;
                    }
                }
                if (bl2) {
                    stringBuffer.append('\"');
                }
                n4 = 0;
                while (n4 < n3) {
                    c10 = string2.charAt(n4);
                    if (c10 == '\"' || c10 == '\\') {
                        stringBuffer.append('\\');
                    }
                    stringBuffer.append(c10);
                    ++n4;
                }
                if (bl2) {
                    stringBuffer.append('\"');
                }
            }
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("DER Value conversion");
        }
        return stringBuffer.toString();
    }
}

