/* -*- Mode: c++; tab-width: 2; indent-tabs-mode: nil; -*- */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef nsStandaloneNativeMenu_h_
#define nsStandaloneNativeMenu_h_

#include "nsMenuGroupOwnerX.h"
#include "nsMenuX.h"
#include "nsIStandaloneNativeMenu.h"

class nsStandaloneNativeMenu : public nsMenuGroupOwnerX, public nsIStandaloneNativeMenu
{
public:
  nsStandaloneNativeMenu();
  virtual ~nsStandaloneNativeMenu();

  NS_DECL_ISUPPORTS  
  NS_DECL_NSISTANDALONENATIVEMENU

  // nsMenuObjectX
  nsMenuObjectTypeX MenuObjectType() { return eStandaloneNativeMenuObjectType; }
  void * NativeData() { return mMenu != nsnull ? mMenu->NativeData() : nsnull; }

  nsMenuX * GetMenuXObject() { return mMenu; }

protected:
  nsMenuX * mMenu;
};

#endif
