/* SPDX-License-Identifier: GPL-2.0 */
/* Copyright (c) Huawei Technologies Co., Ltd. 2025. All rights reserved. */

#ifndef _HINIC3_CSR_H_
#define _HINIC3_CSR_H_

#define HINIC3_CFG_REGS_FLAG                  0x40000000
#define HINIC3_REGS_FLAG_MASK                 0x3FFFFFFF

#define HINIC3_VF_CFG_REG_OFFSET              0x2000

/* HW interface registers */
#define HINIC3_CSR_FUNC_ATTR0_ADDR            (HINIC3_CFG_REGS_FLAG + 0x0)
#define HINIC3_CSR_FUNC_ATTR1_ADDR            (HINIC3_CFG_REGS_FLAG + 0x4)
#define HINIC3_CSR_FUNC_ATTR2_ADDR            (HINIC3_CFG_REGS_FLAG + 0x8)
#define HINIC3_CSR_FUNC_ATTR3_ADDR            (HINIC3_CFG_REGS_FLAG + 0xC)
#define HINIC3_CSR_FUNC_ATTR4_ADDR            (HINIC3_CFG_REGS_FLAG + 0x10)
#define HINIC3_CSR_FUNC_ATTR5_ADDR            (HINIC3_CFG_REGS_FLAG + 0x14)
#define HINIC3_CSR_FUNC_ATTR6_ADDR            (HINIC3_CFG_REGS_FLAG + 0x18)

#define HINIC3_FUNC_CSR_MAILBOX_DATA_OFF      0x80
#define HINIC3_FUNC_CSR_MAILBOX_CONTROL_OFF   (HINIC3_CFG_REGS_FLAG + 0x0100)
#define HINIC3_FUNC_CSR_MAILBOX_INT_OFF       (HINIC3_CFG_REGS_FLAG + 0x0104)
#define HINIC3_FUNC_CSR_MAILBOX_RESULT_H_OFF  (HINIC3_CFG_REGS_FLAG + 0x0108)
#define HINIC3_FUNC_CSR_MAILBOX_RESULT_L_OFF  (HINIC3_CFG_REGS_FLAG + 0x010C)

#define HINIC3_CSR_DMA_ATTR_TBL_ADDR          (HINIC3_CFG_REGS_FLAG + 0x380)
#define HINIC3_CSR_DMA_ATTR_INDIR_IDX_ADDR    (HINIC3_CFG_REGS_FLAG + 0x390)

/* MSI-X registers */
#define HINIC3_CSR_FUNC_MSI_CLR_WR_ADDR       (HINIC3_CFG_REGS_FLAG + 0x58)

#define HINIC3_MSI_CLR_INDIR_RESEND_TIMER_CLR_MASK  BIT(0)
#define HINIC3_MSI_CLR_INDIR_INT_MSK_SET_MASK       BIT(1)
#define HINIC3_MSI_CLR_INDIR_INT_MSK_CLR_MASK       BIT(2)
#define HINIC3_MSI_CLR_INDIR_AUTO_MSK_SET_MASK      BIT(3)
#define HINIC3_MSI_CLR_INDIR_AUTO_MSK_CLR_MASK      BIT(4)
#define HINIC3_MSI_CLR_INDIR_SIMPLE_INDIR_IDX_MASK  GENMASK(31, 22)
#define HINIC3_MSI_CLR_INDIR_SET(val, member)  \
	FIELD_PREP(HINIC3_MSI_CLR_INDIR_##member##_MASK, val)

/* EQ registers */
#define HINIC3_AEQ_INDIR_IDX_ADDR      (HINIC3_CFG_REGS_FLAG + 0x210)
#define HINIC3_CEQ_INDIR_IDX_ADDR      (HINIC3_CFG_REGS_FLAG + 0x290)

#define HINIC3_EQ_INDIR_IDX_ADDR(type)  \
	((type == HINIC3_AEQ) ? HINIC3_AEQ_INDIR_IDX_ADDR :  \
	 HINIC3_CEQ_INDIR_IDX_ADDR)

#define HINIC3_AEQ_MTT_OFF_BASE_ADDR   (HINIC3_CFG_REGS_FLAG + 0x240)
#define HINIC3_CEQ_MTT_OFF_BASE_ADDR   (HINIC3_CFG_REGS_FLAG + 0x2C0)

#define HINIC3_CSR_EQ_PAGE_OFF_STRIDE  8

#define HINIC3_AEQ_HI_PHYS_ADDR_REG(pg_num)  \
	(HINIC3_AEQ_MTT_OFF_BASE_ADDR + (pg_num) *  \
	 HINIC3_CSR_EQ_PAGE_OFF_STRIDE)

#define HINIC3_AEQ_LO_PHYS_ADDR_REG(pg_num)  \
	(HINIC3_AEQ_MTT_OFF_BASE_ADDR + (pg_num) *  \
	 HINIC3_CSR_EQ_PAGE_OFF_STRIDE + 4)

#define HINIC3_CEQ_HI_PHYS_ADDR_REG(pg_num)  \
	(HINIC3_CEQ_MTT_OFF_BASE_ADDR + (pg_num) *  \
	 HINIC3_CSR_EQ_PAGE_OFF_STRIDE)

#define HINIC3_CEQ_LO_PHYS_ADDR_REG(pg_num)  \
	(HINIC3_CEQ_MTT_OFF_BASE_ADDR + (pg_num) *  \
	 HINIC3_CSR_EQ_PAGE_OFF_STRIDE + 4)

#define HINIC3_CSR_AEQ_CTRL_0_ADDR           (HINIC3_CFG_REGS_FLAG + 0x200)
#define HINIC3_CSR_AEQ_CTRL_1_ADDR           (HINIC3_CFG_REGS_FLAG + 0x204)
#define HINIC3_CSR_AEQ_PROD_IDX_ADDR         (HINIC3_CFG_REGS_FLAG + 0x20C)
#define HINIC3_CSR_AEQ_CI_SIMPLE_INDIR_ADDR  (HINIC3_CFG_REGS_FLAG + 0x50)

#define HINIC3_CSR_CEQ_PROD_IDX_ADDR         (HINIC3_CFG_REGS_FLAG + 0x28c)
#define HINIC3_CSR_CEQ_CI_SIMPLE_INDIR_ADDR  (HINIC3_CFG_REGS_FLAG + 0x54)

#endif
